title Start-up code for win32 programs written in ASM with Visual Assembler

;I'm not sure if you can use this module, it should be easier to
;add/delete code from the module (through Visual Assembler)

;This is a Win32 start up module for Visual Assembler.
;I've added a lot of comments, so even newbies without knowledge of
;win32 ASM can understand what I try to code here...
;I tested this code with TASM 4.10, TASM32 v5.0

        .386
        .model  flat,stdcall            ;32-bit flat windows model
        locals  @@

;IMPORTANT:
TASM            equ     1               ;Define this if you use TASM
;UNICODE         equ     1               ;Uncomment this for UNICODE support

        include windows.inc

;------ Start of extrns ---------------------------------------
        extrnp  GetModuleHandle,GetCommandLine
        extrnp  GetMessage,DispatchMessage
        extrnp  RegisterClassEx
        extrnp  LoadIcon,LoadCursor
        extrnp  CreateWindowEx

        extrn   GetStockObject:near
        extrn   ExitProcess:near
        extrn   TranslateMessage:near
        extrn   InitCommonControls:near
        extrn   ShowWindow:near,UpdateWindow:near

        extrn   WndProc:near
;------ End of extrns -----------------------------------------

;------ Start of publics --------------------------------------
        public  g_hInstance,g_lpszCmdLine,g_hWnd
;------ End of publics ----------------------------------------

        .data?
g_hInstance     dd      ?               ;Our hInstance
g_lpszCmdLine   dd      ?               ;Pointer to our command line
g_hWnd          dd      ?               ;Our main window's hWnd

        .const
;TODO: UNICODE is not supported here...
szAppName       db      'MyWinApp',0
szWindowName    db      'VisAsm App for win32',0 ;Put your program name here

        .code
start:                                  ;We start here.
        call    InitCommonControls      ;What it sounds like
        push    NULL
        call    GetModuleHandle
        mov     g_hInstance,eax         ;Save hInstance (usually 400000h)
        call    GetCommandLine
        mov     g_lpszCmdLine,eax       ;Save the command line (unicode/ansi)

        call    InitMyApp               ;Initialize your app
        jc      short exit              ;If it couldn't be initialized

        sub     esp,(size MSG+3) and not 3
        xor     ebx,ebx                 ;Zero EBX
MessageLoop:                            ;The (in)famous windows msg loop
        mov     eax,esp                 ;EAX=offset of a MSG struc
        push    ebx
        push    ebx
        push    ebx
        push    eax
        call    GetMessage
        test    eax,eax                 ;If EAX=0, we must exit
        jz      short exit              ;Jump if EAX is zero (and return 0)

if 0
  if 0
        ;If you use MDI windows, you must add this code.
        ;You must define hWndClient before you can use it.
        extrn   TranslateMDISysAccel:near
        push    esp
        push    hWndClient
        call    TranslateMDISysAccel
        test    eax,eax                 ;If TRUE, continue looping
        jnz     short MessageLoop
  endif
        ;If you use accelerator messages, add this code
        ;Define hAccel first
        extrnp  TranslateAccelerator    ;This is a unicode function
        push    esp
        push    hAccel
        push    g_hWnd                  ;This should be the handle to the frame window
        call    TranslateAccelerator
        test    eax,eax
        jnz     short MessageLoop
endif
        push    esp
        call    TranslateMessage        ;Only needed if you use the keyboard
        push    esp
        call    DispatchMessage         ;Pass the message to your window
        jmp     short MessageLoop       ;And loop again
exit:
        push    eax
        call    ExitProcess

;Initialize your application
;In:    You decide
;Out:   CF=1    If you couldn't initialize everything
;         EAX   Error code to pass to windows
;       CF=0    Ok, run the thing
;Regs:  You decide
InitMyApp       proc near
        call    InitMyWindow
        jc      @@Stc

        push    NULL                    ;lpParam
        push    g_hInstance             ;hInstance
        push    NULL                    ;hMenu
        push    NULL                    ;hWndParent
        push    CW_USEDEFAULT           ;nHeight
        push    CW_USEDEFAULT           ;nWidth
        push    CW_USEDEFAULT           ;y
        push    CW_USEDEFAULT           ;x
        push    WS_OVERLAPPEDWINDOW     ;style
        push    offset szWindowName     ;lpWindowName
        push    offset szAppName        ;lpClassName
        push    WS_EX_OVERLAPPEDWINDOW  ;dwExStyle
        call    CreateWindowEx          ;Create the window
        test    eax,eax
        jz      short @@Stc             ;Exit with error
        mov     g_hWnd,eax              ;Save hWnd where we can reach it

        push    eax                     ;hWnd for UpdateWindow
        push    SW_SHOWNORMAL
        push    eax
        call    ShowWindow
        call    UpdateWindow
        clc                             ;No error
@@End:
        retn
@@Stc:
        or      eax,0FFFFFFFFh          ;Error code
        stc
        jc      short @@End
InitMyApp       endp

;Initialize your window and register it
;In:    None
;Out:   CF=1    Error
;       CF=0    No error
;Regs:  EAX,ECX,EDX
InitMyWindow    proc near
        ;NOTE: Tasm adds "enter LocalSize,00h", but it doesn't add
        ;epilogue code (leaved, or mov esp,ebp pop ebp). Bug?
        local   @@wc:WNDCLASSEX=LocalSize
        mov     @@wc.cbSize,size WNDCLASSEX
        mov     @@wc.style,CS_HREDRAW or CS_VREDRAW ;Add your style here
        mov     @@wc.lpfnWndProc,offset WndProc
        mov     @@wc.cbClsExtra,00000000h
        mov     @@wc.cbWndExtra,00000000h
        mov     eax,g_hInstance
        mov     @@wc.hInstance,eax

        push    IDI_APPLICATION         ;Insert your Icon equate here
        push    NULL                    ;Use g_hInstance here if your Icon!!!
        call    LoadIcon
        mov     @@wc.hIcon,eax

        push    IDC_ARROW               ;Insert your Cursor equate here
        push    NULL                    ;User g_hInstance here if your Cursor!!!
        call    LoadCursor
        mov     @@wc.hCursor,eax

        push    WHITE_BRUSH
        call    GetStockObject
        mov     @@wc.hbrBackground,eax

        mov     @@wc.lpszMenuName,NULL
        mov     @@wc.lpszClassName,offset szAppName

        push    IDI_APPLICATION         ;Insert your IconSm equate here
        push    NULL                    ;Use g_hInstance here if your IconSm
        call    LoadIcon
        mov     @@wc.hIconSm,eax

        lea     eax,@@wc                ;Get address of @@wc structure
        push    eax
        call    RegisterClassEx
        test    eax,eax                 ;Any error(s)?
        jnz     short @@666
        cmc                             ;Set carry flag (since CF=0)
@@666:
        leaved
        retn
InitMyWindow    endp

        end     start
